<style>
    @import url('https://fonts.googleapis.com/css2?family=Inconsolata:wght@200..900&display=swap');


    .page {
        width: 70mm !important;
        font-family: "Inconsolata", monospace;
        font-optical-sizing: auto;
        font-style: normal;
    }

    .page h4,
    h5 {
        text-align: center;
    }


    @media print {

        @page {
            margin: 0;

        }

        .alamat {
            display: flex;
            justify-content: center;
            text-align: center;
            line-height: 15px;
            font-size: 15px;
            margin-top: -10px;
        }

        table.tabprint {
            width: 100%;
        }

        .tabprint tr th {
            font-weight: 500;
            text-transform: uppercase;
            text-align: center !important;
            line-height: 15px;
            font-size: 15px;
        }

        .tabprint tr td {
            line-height: 15px;
            font-size: 17px;
        }

        table.tabprint2 {
            width: 100%;
        }

        .tabprint2 tr td {
            line-height: 18px;
            font-size: 17px;
        }

    }
</style>
<div class="page">
    <h4 style="font-size: 17pt; margin-bottom: 10px; text-transform: uppercase; margin-top: 10px;">
        {{ modull('PNT')->judul }}
    </h4>
    <div class="alamat">Email : {{ modull('PNT')->gambar }} <br> Telp- : {{ modull('PNT')->link }} <br>
        {{ modull('PNT')->isi }}</div>
    <table class="tabprint">
        <tr>
            <td colspan="3">======================================</td>
        </tr>
        <tr>
            <td width="31%">No. Trans</td>
            <td width="1%">:</td>
            <td>{{ $t->kd_transaksi }}</td>
        </tr>
        <tr>
            <td width="31%">Tanggal</td>
            <td width="1%">:</td>
            <td>{{ date('d-m-Y H:i', strtotime($t->created_at)) }}</td>
        </tr>
        <tr>
            <td>MEMBER</td>
            <td>:</td>
            <td>{{ $t->member->nm_member }}</td>
        </tr>
        <tr>
            <td>Ptg. Entry</td>
            <td>:</td>
            <td>{{ $t->user->nm_user }}</td>
        </tr>
    </table>
    <div>======================================</div>
    <table class="tabprint2">

        @foreach ($t->keranjang()->get() as $k)
            <tr>
                <td colspan="3">{{ $k->produk->nm_produk }}</td>
            </tr>
            <tr>
                <td colspan="2">{{ $k->jumlah }} x
                    {{ number_format($k->harga - ($k->harga * $k->diskon) / 100, 0, ',', '.') }}
                </td>
                <td class="text-right">
                    {{ number_format(($k->harga - ($k->harga * $k->diskon) / 100) * $k->jumlah, 0, ',', '.') }}
                </td>
            </tr>
        @endforeach

    </table>
    <div>======================================</div>
    <table class="tabprint2">
        @if ($t->diskon != 0)
            <tr>
                <td class="text-right">Subtotal </td>
                <td class="text-right" width="15%">Rp. </td>
                <td class="text-right">{{ number_format($t->jumlah, 0, ',', '.') }}</td>
            </tr>
            <tr>
                <td class="text-right">Diskon </td>
                <td class="text-right"></td>
                <td class="text-right">{{ number_format($t->diskon, 0, ',', '.') }}%</td>
            </tr>
        @endif
        @if ($t->sts_antar == 'Y')
            <tr>
                <td class="text-right">Ongkir </td>
                <td class="text-right" width="15%">Rp. </td>
                <td class="text-right">{{ number_format($t->ongkir, 0, ',', '.') }}</td>
            </tr>
        @endif
        <tr>
            <td class="text-right">Total </td>
            <td class="text-right" width="15%">Rp. </td>
            <td class="text-right">{{ number_format($t->total, 0, ',', '.') }}</td>
        </tr>
        <tr>
            <td class="text-right">Bayar </td>
            <td class="text-right">Rp. </td>
            <td class="text-right">{{ number_format($t->dibayar, 0, ',', '.') }}</td>
        </tr>
        <tr>
            <td class="text-right">Kembali </td>
            <td class="text-right">Rp. </td>
            <td class="text-right">{{ number_format($t->dibayar - $t->total, 0, ',', '.') }}</td>
        </tr>
    </table>
    <div>======================================</div>
    <table class="tabprint">
        <tr>
            <td><br></td>
        </tr>
        <tr>
            <th>
                {{ modull('PTX')->judul }} <br>
                @php
                    $cek = poinbaru($t->kd_transaksi);
                @endphp
                @if ($cek != 0)
                    Poin {{ $cek }}
                @endif
                <br>
                {!! modull('PTX')->isi !!}
            </th>
        </tr>
        <tr>
            <td></td>
        </tr>
        {{-- <tr>
            <td class="d-flex  justify-content-center">
                <div class="">
                    {!! '<img src="data:image/png;base64,' .
                        DNS1D::getBarcodePNG($t->kd_transaksi, 'C39+', 1, 29) .
                        '" alt="barcode"   />' !!}
                </div>
            </td>
        </tr> --}}
        <tr>
            <td></td>
        </tr>
        <tr>
            <td class="text-center"> {!! modull('PTX')->link !!}</td>
        </tr>
    </table>
</div>
